<?php
header("Pragma: no-cache");
header("Cache-Control: max-age=1, s-maxage=1, no-cache, must-revalidate");
session_start();
unset($_SESSION['validate']);

$randStr = array(rand(0, 9), rand(0, 9), rand(0, 9), rand(0, 9));  // 4ַ
$_SESSION['validate'] = $randStr[0].$randStr[1].$randStr[2].$randStr[3];

function RgbToHsv($R, $G, $B)
{
 $tmp = min($R, $G);
  $min = min($tmp, $B);
  $tmp = max($R, $G);
  $max = max($tmp, $B);
  $V = $max;
  $delta = $max - $min;

  if($max != 0)
   $S = $delta / $max; // s
  else
  {
   $S = 0;
    //$H = UNDEFINEDCOLOR;
    return;
  }
  if($R == $max)
   $H = ($G - $B) / $delta; // between yellow & magenta
  else if($G == $max)
    $H = 2 + ($B - $R) / $delta; // between cyan & yellow
  else
    $H = 4 + ($R - $G) / $delta; // between magenta & cyan

  $H *= 60; // degrees
  if($H < 0)
   $H += 360;
  return array($H, $S, $V);
}

function HsvToRgb($H, $S, $V)
{
 if($S == 0)
  {
   // achromatic (grey)
   $R = $G = $B = $V;
    return;
  }

  $H /= 60;  // sector 0 to 5
  $i = floor($H);
  $f = $H - $i;  // factorial part of h
  $p = $V * (1 - $S);
  $q = $V * (1 - $S * $f);
  $t = $V * (1 - $S * (1 - $f));

  switch($i)
  {
   case 0:
     $R = $V;
      $G = $t;
      $B = $p;
      break;
    case 1:
      $R = $q;
      $G = $V;
      $B = $p;
      break;
    case 2:
      $R = $p;
      $G = $V;
      $B = $t;
      break;
    case 3:
      $R = $p;
      $G = $q;
      $B = $V;
      break;
    case 4:
      $R = $t;
      $G = $p;
      $B = $V;
      break;
    default: // case 5:
      $R = $V;
      $G = $p;
      $B = $q;
      break;
 }
  return array($R, $G, $B);
}

$size = 20;
$width = 80;
$height = 25;
$degrees = array(rand(0, 45), rand(0, 45), rand(0, 45), rand(0, 45)); // תǶ

for($i = 0; $i < 4; ++$i)
{
 if(rand() % 2);
 else $degrees[$i] = -$degrees[$i];
}

$image = imagecreatetruecolor($size, $size);   // ͼƬ
$validate = imagecreatetruecolor($width, $height);  // ֤뻭
$back = imagecolorallocate($image, 255, 255, 255);  // ɫ
$border = imagecolorallocate($image, 0, 0, 0);    // ߿
imagefilledrectangle($validate, 0, 0, $width, $height, $back); // ɫ

// ɫ
for($i = 0; $i < 4; ++$i)
{
 // Ϊʹַ׿ʹɫϰɫ
 $temp = RgbToHsv(rand(0, 255), rand(0, 255), rand(0, 255));
 
 if($temp[2] > 60)
  $temp [2] = 60;

 $temp = HsvToRgb($temp[0], $temp[1], $temp[2]);
 $textcolor[$i] = imagecolorallocate($image, $temp[0], $temp[1], $temp[2]);
}

for($i = 0; $i < 200; ++$i) //
{
 $randpixelcolor = ImageColorallocate($validate, rand(0, 255), rand(0, 255), rand(0, 255));
 imagesetpixel($validate, rand(1, 87), rand(1, 27), $randpixelcolor);
}

// ʹɫɫ
$temp = RgbToHsv(rand(0, 255), rand(0, 255), rand(0, 255));

if($temp[2] < 200)
 $temp [2] = 255;
 
$temp = HsvToRgb($temp[0], $temp[1], $temp[2]);
$randlinecolor = imagecolorallocate($image, $temp[0], $temp[1], $temp[2]);

// 5
for ($i = 0;$i < 5; $i ++)
 imageline($validate, rand(1, 79), rand(1, 24), rand(1, 79), rand(1, 24), $randpixelcolor);

imagefilledrectangle($image, 0, 0, $size, $size, $back); // ɫ 
imagestring($image, 5, 6, 2, $randStr[0], $textcolor[0]);  // 
$image = imagerotate($image, $degrees[0], $back);
imagecolortransparent($image, $back);
imagecopymerge($validate, $image, 1, 4, 4, 5, imagesx($image) - 10, imagesy($image) - 10, 100);

$image = imagecreatetruecolor($size, $size); // ˢ»
imagefilledrectangle($image, 0, 0, $size, $size, $back);  // ɫ 
imagestring($image, 5, 6, 2, $randStr[1], $textcolor[1]);  // 
$image = imagerotate($image, $degrees[1], $back);
imagecolortransparent($image, $back);
imagecopymerge($validate, $image, 21, 4, 4, 5, imagesx($image) - 10, imagesy($image) - 10, 100);

$image = imagecreatetruecolor($size, $size); // ˢ»
imagefilledrectangle($image, 0, 0, $size - 1, $size - 1, $back);  // ɫ 
imagestring($image, 5, 6, 2, $randStr[2], $textcolor[2]);  // 
$image = imagerotate($image, $degrees[2], $back);
imagecolortransparent($image, $back);
imagecopymerge($validate, $image, 41, 4, 4, 5, imagesx($image) - 10, imagesy($image) - 10, 100);

$image = imagecreatetruecolor($size, $size); // ˢ»
imagefilledrectangle($image, 0, 0, $size - 1, $size - 1, $back);  // ɫ 
imagestring($image, 5, 6, 2, $randStr[3], $textcolor[3]);  // 
$image = imagerotate($image, $degrees[3], $back);
imagecolortransparent($image, $back);
imagecopymerge($validate, $image, 61, 4, 4, 5, imagesx($image) - 10, imagesy($image) - 10, 100);

imagerectangle($validate, 0, 0, $width - 1, $height - 1, $border);  // ߿

header('Content-type: image/png');
imagepng($validate);
imagedestroy($validate);
imagedestroy($image);
?>